/* global Twitch */

import Component from 'ember-component';
import moment from 'moment';
import $ from 'jquery';

export const DAYS_RESOLUTION = 'days';
export const WEEKS_RESOLUTION = 'weeks';
export const MONTHS_RESOLUTION = 'months';

// http://momentjs.com/docs/#/displaying/format
export const DATE_FORMAT = 'll';
export const WEEK_FORMAT = 'MMM D';
export const MONTH_FORMAT = 'MMM YYYY';

const OPTIONS = [
  {
    label: 'Days',
    resolution: DAYS_RESOLUTION,
    component: 'dashboards/revenue/date-picker/date-picker-by-date'
  },
  {
    label: 'Weeks',
    resolution: WEEKS_RESOLUTION,
    component: 'dashboards/revenue/date-picker/date-picker-by-week'
  },
  {
    label: 'Months',
    resolution: MONTHS_RESOLUTION,
    component: 'dashboards/revenue/date-picker/date-picker-by-month'
  }
];

export default Component.extend({
  classNames: ['flex', 'float-left'],

  // Passed in properties:
  isDateFilterDisabled: false,
  updateRevenueData: null,

  // Own properties:
  momentStartDate: null,
  momentEndDate: null,
  options: null,
  selectedOption: null,

  init() {
    this._super(...arguments);

    this._setLocale();

    this.set('momentStartDate', moment().startOf('day').subtract(1, 'month'));
    this.set('momentEndDate', moment().startOf('day'));
    this.set('options', OPTIONS);
    this.set('selectedOption', OPTIONS[0]);
  },

  actions: {
    select(option) {
      if (this.get('selectedOption.resolution') === option.resolution) { return; }

      this.set('selectedOption', option);
    }
  },

  _setLocale() {
    let language = Twitch.receivedLanguage || 'en';

    moment.locale(language);

    switch (language) {
      case ('iw'):
        language = 'he';
        break;
      case ('pt-br'):
        language = 'pt-BR';
        break;
      case ('zh-cn'):
        language = 'zh-CN';
        break;
      case ('zh-tw'):
        language = 'zh-TW';
        break;
      case ('en'):
        language = '';
        break;
    }

    $.datepicker.setDefaults($.datepicker.regional[language]);
  }
});
