import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  api: injectService(),

  // Passed-in property:
  channelId: null,
  closeModal: null,

  // Own properties:
  hasConfirmedEmailingSubscriberList: false,
  hasEmailingSubscriberListErrored: false,
  isEmailingSubscriberList: false,
  
  partnerEmailAddress: null,

  actions: {
    closeModal() {
      this.get('closeModal')();
    },

    emailSubscribersList() {
      this.set('isEmailingSubscriberList', true);

      let api = this.get('api');
      let channelId = this.get('channelId');
      let url = `/api/channels/${ channelId }/subscriber_list_email`;

      return api.request('post', url)
        .then(response => {
          if (this.isDestroyed) { return; }

          let payload = response.message;
          let partnerEmailAddress = payload.substring(20);

          this.set('partnerEmailAddress', partnerEmailAddress);
          this.set('hasConfirmedEmailingSubscriberList', true);
        }).catch(() => {
          if (this.isDestroyed) { return; }

          this.set('hasEmailingSubscriberListErrored', true);
        }).finally(() => {
          if (this.isDestroyed) { return ;}

          this.set('isEmailingSubscriberList', false);
        });
    }
  }
});
