/* globals i18n */

import Component from 'ember-component';
import { USDCurrency } from 'web-client/helpers/usd-currency';

const TOOLTIP_FOOTER = i18n('Total');

const REVENUE_CHART_OPTIONS = {
  tooltips: {
    backgroundColor: 'rgba(0,0,0,0.8)',
    titleFontFamily: `'Helvetica Neue', 'Helvetica', 'Arial', sans-serif`,
    titleFontSize: 12,
    titleFontColor: '#fff',
    titleSpacing: 2,
    titleMarginBottom: 6,
    bodyFontColor: '#fff',
    bodyFontStyle: 'normal',
    bodySpacing: 2,
    footerFontColor: '#fff',
    footerSpacing: 2,
    footerMarginTop: 6,
    xPadding: 6,
    yPadding: 6,
    enabled: true,
    mode: 'label',
    caretSize: 4,
    callbacks: {
      title(items) {
        return items[0].xLabel;
      },
      label(items, data) {
        return `${ data.datasets[items.datasetIndex].label }: ${ USDCurrency(items.yLabel) }`;
      },
      footer(items) {
        let totalValue = 0;

        items.forEach(item => {
          totalValue += item.yLabel;
        });

        return `${ TOOLTIP_FOOTER }: ${ USDCurrency(totalValue) }`;
      }
    }
  },
  legend: {
    position: 'bottom',
    labels: {
      boxWidth: 12
    }
  },
  responsive: true,
  maintainAspectRatio: false,
  scales: {
    xAxes: [
      {
        stacked: true,
        gridLines: {
          display: false
        },
        ticks: {
          display: false
        }
      }
    ],
    yAxes: [
      {
        stacked: true,
        gridLines: {
          display: true,
          color: 'rgba(0,0,0,0)',
          zeroLineColor: 'rgba(0,0,0,0.2)'
        },
        ticks: {
          min: 0,
          suggestedMax: 1,
          maxTicksLimit: 6,
          callback(value, index, values) {
            return USDCurrency(value, Math.max(...values));
          }
        }
      }
    ]
  }
};

const SUBCRIPTIONS_CHART_OPTIONS = {
  tooltips: {
    enabled: true,
    backgroundColor: 'rgba(0,0,0,0.8)',
    titleFontFamily: `'Helvetica Neue', 'Helvetica', 'Arial', sans-serif`,
    titleFontSize: 12,
    titleFontColor: '#fff',
    titleSpacing: 2,
    titleMarginBottom: 6,
    bodyFontColor: '#fff',
    bodyFontStyle: 'normal',
    bodySpacing: 2,
    xPadding: 6,
    yPadding: 6,
    caretSize: 4,
    callbacks: {
      title(items) {
        return items[0].xLabel;
      },
      label(items, data) {
        return `${ data.datasets[items.datasetIndex].label }: ${ items.yLabel }`;
      }
    }
  },
  legend: {
    position: 'bottom',
    labels: {
      boxWidth: 12
    }
  },
  responsive: true,
  maintainAspectRatio: false,
  scales: {
    xAxes: [
      {
        stacked: true,
        gridLines: {
          display: false,
          color: 'rgba(0,0,0,0.05)',
          zeroLineColor: 'rgba(0,0,0,0.05)'
        },
        ticks: {
          display: false
        }
      }
    ],
    yAxes: [
      {
        stacked: false,
        gridLines: {
          display: false
        },
        ticks: {
          min: 0,
          suggestedMax: 1,
          maxTicksLimit: 6,
          callback(value) {
            return (value % 1 === 0) ? Number(value).toFixed(0) : '';
          }
        }
      }
    ]
  }
};

export default Component.extend({
  classNames: ['dataWrap', 'dataWrap--partnerRev', 'brick', 'brick--faint'],

  // Passed in properties:
  revenueData: null,
  subscriptionsData: null,
  isRevLoading: true,
  isSubLoading: true,

  // Internal properties
  isRevenueSelected: true,
  revenueChartOptions: REVENUE_CHART_OPTIONS,
  subscriptionsChartOptions: SUBCRIPTIONS_CHART_OPTIONS,

  actions: {
    selectRevenue() {
      this.set('isRevenueSelected', true);
    },

    selectSubscriptions() {
      this.set('isRevenueSelected', false);
    }
  }
});
