/* globals i18n */

import Component from 'ember-component';
import computed from 'ember-computed';

const UP_TOOLTIP = i18n('Up from ${{amount}} in previous period ({{startDate}} - {{endDate}})');
const DOWN_TOOLTIP = i18n('Down from ${{amount}} in previous period ({{startDate}} - {{endDate}})');

export default Component.extend({
  classNames: ['revHeader', 'flex'],

  // Passed in properties:
  isLoading: true,

  rangeSubRevenue: 0,
  rangeAdRevenue: 0,
  rangeTPrimeRevenue: 0,
  rangeBitsRevenue: 0,

  compareStartDate: null,
  compareEndDate: null,
  compareRangeSubRevenue: 0,
  compareRangeTPrimeRevenue: 0,
  compareRangeAdRevenue: 0,
  compareRangeBitsRevenue: 0,

  isBitsOnboarded: false,

  // Own computed properties:
  rangeTotalRevenue: computed('rangeSubRevenue', 'rangeAdRevenue', 'rangeBitsRevenue', 'rangeTPrimeRevenue', function () {
    return this.get('rangeSubRevenue') + this.get('rangeAdRevenue') + this.get('rangeBitsRevenue') + this.get('rangeTPrimeRevenue');
  }),

  compareRangeTotalRevenue: computed('compareRangeSubRevenue', 'compareRangeAdRevenue', 'compareRangeBitsRevenue', 'compareRangeTPrimeRevenue', function () {
    return this.get('compareRangeSubRevenue') + this.get('compareRangeAdRevenue') + this.get('compareRangeBitsRevenue') + this.get('compareRangeTPrimeRevenue');
  }),

  subRevTooltip: computed('subRevArrowUp', 'compareRangeSubRevenue', 'compareStartDate', 'compareEndDate', function() {
    return this._tooltipMessage(this.get('compareRangeSubRevenue'), this.get('subRevArrowUp'));
  }),

  subRevArrowUp: computed('rangeSubRevenue', 'compareRangeSubRevenue', function () {
    return this.get('rangeSubRevenue') >= this.get('compareRangeSubRevenue');
  }),

  adRevTooltip: computed('adRevArrowUp', 'compareRangeAdRevenue', 'compareStartDate', 'compareEndDate', function() {
    return this._tooltipMessage(this.get('compareRangeAdRevenue'), this.get('adRevArrowUp'));
  }),

  adRevArrowUp: computed('rangeAdRevenue', 'compareRangeAdRevenue', function () {
    return this.get('rangeAdRevenue') >= this.get('compareRangeAdRevenue');
  }),

  tPrimeRevTooltip: computed('tPrimeRevArrowUp', 'compareRangeTPrimeRevenue', 'compareStartDate', 'compareEndDate', function () {
    return this._tooltipMessage(this.get('compareRangeTPrimeRevenue'), this.get('tPrimeRevArrowUp'));
  }),

  tPrimeRevArrowUp: computed('rangeTPrimeRevenue', 'compareRangeTPrimeRevenue', function () {
    return this.get('rangeTPrimeRevenue') >= this.get('compareRangeTPrimeRevenue');
  }),

  bitsRevTooltip: computed('bitsRevArrowUp', 'compareRangeBitsRevenue', 'compareStartDate', 'compareEndDate', function() {
    return this._tooltipMessage(this.get('compareRangeBitsRevenue'), this.get('bitsRevArrowUp'));
  }),

  bitsRevArrowUp: computed('rangeBitsRevenue', 'compareRangeBitsRevenue', function () {
    return this.get('rangeBitsRevenue') >= this.get('compareRangeBitsRevenue');
  }),

  totalRevTooltip: computed('totalRevArrowUp', 'compareRangeTotalRevenue', 'compareStartDate', 'compareEndDate', function() {
    return this._tooltipMessage(this.get('compareRangeTotalRevenue'), this.get('totalRevArrowUp'));
  }),

  totalRevArrowUp: computed('rangeTotalRevenue', 'compareRangeTotalRevenue', function () {
    return this.get('rangeTotalRevenue') >= this.get('compareRangeTotalRevenue');
  }),

  /*
    amount: a floating number of the compare range revenue
    up: a boolean, if true, then revenue went up
  */
  _tooltipMessage(amount, up) {
    let startDate = this.get('compareStartDate').format('ll');
    let endDate = this.get('compareEndDate').format('ll');
    let message = up ? UP_TOOLTIP : DOWN_TOOLTIP;
    let fixedAmount = amount.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ',');

    return message.replace('{{amount}}', fixedAmount).replace('{{startDate}}', startDate).replace('{{endDate}}', endDate);
  }
});
