import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  subscriptions: injectService(),

  /* Passed in properties */
  channelId: null,

  /* Internal properties */
  subscriptionsCount: null,
  isGettingSubscriptionsCount: true,
  isShowingSendEmailToSubscribersModal: false,
  isShowingEmailSubscribersListModal: false,

  init() {
    this._super(...arguments);

    let channelLogin = this.get('channelId');
    let subscriptions = this.get('subscriptions');

    subscriptions.getSubscriberCount({ channelLogin })
      .then(response => {
        if (this.isDestroyed) { return; }

        this.set('subscriptionsCount', response.count);
      })
      .finally(() => {
        if (this.isDestroyed) { return; }

        this.set('isGettingSubscriptionsCount', false);
      });
  },

  actions: {
    openEmailSubscriberListModal() {
      this.set('isShowingEmailSubscribersListModal', true);
      this.set('isShowingSendEmailToSubscribersModal', false);
    },

    openSendEmailToSubscribersModal() {
      this.set('isShowingSendEmailToSubscribersModal', true);
      this.set('isShowingEmailSubscribersListModal', false);
    },

    closeEmailSubscriberListModal() {
      this.set('isShowingEmailSubscribersListModal', false);
    },

    closeSendEmailToSubscribersModal() {
      this.set('isShowingSendEmailToSubscribersModal', false);
    }
  }
});
