import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  api: injectService(),

  classNames: ['brick', 'brick--theme-grey', 'brick--pd-lg'],

  // Passed in properties
  userId: null,

  // Internal properties
  isShowingStreamKeyModal: false,
  isShowingStreamKey: false,
  streamKey: null,
  streamKeyError: false,

  actions: {
    closeModal() {
      this.set('isShowingStreamKeyModal', false);
      this.set('isShowingStreamKey', false);
    },

    openModal() {
      this.set('isShowingStreamKeyModal', true);
    },

    showStreamKey() {
      this.get('api')
        .request('get', '/kraken/channel')
        .then(response => {
          if (this.isDestroyed) { return; }

          this.set('streamKey', response.stream_key);
          this.set('isShowingStreamKey', true);
        }, () => {
          if (this.isDestroyed) { return; }

          this.set('streamKeyError', true);
        });
    },

    resetStreamKey() {
      let userId = this.get('userId');

      this.get('api')
        .request('delete', `/kraken/channels/${ userId }/stream_key`)
        .then(response => {
          if (this.isDestroyed) { return; }

          this.set('streamKey', response.stream_key);
          this.set('isShowingStreamKey', true);
        }, () => {
          if (this.isDestroyed) { return; }

          this.set('streamKeyError', true);
        });
    }
  }
});
