import Component from 'ember-component';
import computed from 'ember-computed';
import { assert } from 'ember-metal/utils';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  classNames: ['js-sub-badge-display'],

  // TODO: replace attribute bindings && style w/ class:
  attributeBindings: ['style'],
  style: computed(function () {
    return htmlSafe('display: inline-block; margin-right: 25px; vertical-align: top;');
  }),

  // Passed-in properties:
  imgSrc: null,
  name: null,
  title: null,

  badgeDisplayStyle: computed('imgSrc', function () {
    let imgSrc = this.get('imgSrc');
    let borderStyles = imgSrc ? '' : 'border-width: 2px; border-style: dashed; border-color: #bbb;';

    return htmlSafe(`height: 36px; width: 36px; margin: auto; ${ borderStyles }`);
  }),

  init() {
    this._super(...arguments);

    let name = this.get('name');
    let isNameValid = (typeof name === 'string') && name.length > 0;

    assert(`${this} requires valid argument "name"`, isNameValid);
  }
});
