import Component from 'ember-component';
import { assert } from 'ember-metal/utils';

export default Component.extend({
  tagName: 'button',
  classNames: ['js-sub-badge-tab'],
  classNameBindings: ['isActive:active'],

  // Passed-in properties:
  isActive: null,
  name: null,
  select: null,

  init() {
    this._super(...arguments);

    let isIsActiveValid = typeof this.get('isActive') === 'boolean';
    let isSelectValid = typeof this.get('select') === 'function';
    let name = this.get('name');
    let isNameValid = (typeof name === 'string') && (name.length > 0);

    assert(`${this} requires valid argument "isActive"`, isIsActiveValid);
    assert(`${this} requires valid argument "select"`, isSelectValid);
    assert(`${this} requires valid argument "name"`, isNameValid);
  },

  click() {
    this.sendAction('select');
  }
});
