import Component from 'ember-component';

export default Component.extend({
  tagName: 'iframe',
  classNames: ['tipalti_iframe'],
  attributeBindings: ['src', 'width', 'height'],
  attributes: ['scrolling:no', 'frameborder:0', 'allowTransparency:true'],
  width: "100%",

  didInsertElement() {
    this._super(...arguments);
    this.addEventListener(window, 'message', (e) => {
      if (!e.originalEvent.data) { return; }
      if (!e.originalEvent.data.TipaltiIframeInfo) { return; }
      if (!e.originalEvent.data.TipaltiIframeInfo.height) { return; }

      this.set('height', e.originalEvent.data.TipaltiIframeInfo.height);
    });
  }
});
