import Component from 'ember-component';
import computed from 'ember-computed';

const VIDEO_ROUTE_SHIM = '.video';

export default Component.extend({
  classNames: ['brick', 'brick--theme-grey', 'brick--pd-lg'],

  isVideoHeader: computed.notEmpty('video'),

  videoFallbackRoute: computed('isOverview', function() {
    return this.get('isOverview') ? this.generateOverviewRoute() : this.generateDetailsRoute();
  }),

  searchRoute: computed('isOverview', function() {
    return this.get('isOverview') ? this.generateOverviewRoute(true) : this.generateDetailsRoute(true);
  }),

  overviewRoute: computed('isVideoHeader', function() {
    return this.generateOverviewRoute(!!this.get('isVideoHeader'));
  }),

  detailsRoute: computed('isVideoHeader', function() {
    return this.generateDetailsRoute(!!this.get('isVideoHeader'));
  }),

  generateOverviewRoute(isForVOD = false) {
    let videoShim = isForVOD ? VIDEO_ROUTE_SHIM : '';
    return `dashboards.video-stats${videoShim}.overview`;
  },

  generateDetailsRoute(isForVOD = false) {
    let videoShim = isForVOD ? VIDEO_ROUTE_SHIM : '';
    return `dashboards.video-stats${videoShim}.details`;
  }
});
