import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  classNames: ['video-stats__table', 'col-xs-12', 'col-md-6'],
  limit: 5,
  sortBy: 'minuteswatched',

  init() {
    this._super(...arguments);

    if (!this.tooltip) {
      this.tooltip = '';
    }
  },

  hasToolTip: computed.notEmpty('tooltip'),

  rows: computed('data', 'filter', 'limit', 'sortBy', function() {
    let filter = this.get('filter');
    let rows = this.get('data')
      .getAnalyticsByFilter(filter)
      .sortBy(this.get('sortBy'))
      .reverse();

    return rows.splice(0, this.get('limit'));
  })
});
