import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { TTV_BOXART_404_URL } from 'web-client/utilities/urls/static-cdn';
import run from 'ember-runloop';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';

const UI_CONTEXT = 'community_directory';


export default Component.extend(InteractivityDeferredComponent, {
  session: injectService(),
  tracking: injectService(),

  classNames: ['js-directory-game'],

  boxartPlaceholder: TTV_BOXART_404_URL,

  didInsertElement() {
    this._super();
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  },

  _getTrackingObject(community, index) {
    return {
      community_id: community.get('id'),
      community_name: community.get('name'),
      displayed_ccu: community.get('viewers'),
      login: this.get('session.userData.login'),
      rank_index: index,
      url: window.location.href,
      ui_context: UI_CONTEXT
    };
  },

  actions: {
    handleCommunityClick(community, index) {
      let trackingObject = this._getTrackingObject(community, index);
      this.get('tracking').trackEvent({
        services: ['spade'],
        event: 'community_select_click',
        data: trackingObject
      });
    }
  }
});
