/* globals Twitch */
import Component from 'ember-component';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import computed from 'ember-computed';
import run from 'ember-runloop';


export default Component.extend(InteractivityDeferredComponent, {
  didInsertElement() {
    this._super(...arguments);
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  },
  channelUrl: computed('channel.id', function () {
    return Twitch.uri.channel(this.get('channel.id'));
  })
});
