/* globals Twitch */
import Component from 'ember-component';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import { scheduleOnce } from 'ember-runloop';

export default Component.extend(InteractivityDeferredComponent, {
  click() {
    this.sendAction('openInModal', 'shared/following-games-onboard-modal', 'followingGamesOnboardModal');
    Twitch.tracking.funnel.trackPageView({location: "game-follow-onboard"});
  },

  didInsertElement() {
    this._super(...arguments);
    scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
