import computed from 'ember-computed';
import Component from 'ember-component';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  productDescription: computed('product', function() {
    return htmlSafe(this.get('product.description'));
  }),

  productFeatures: computed('product.feature_details.[]', function() {
    return this.get('product.feature_details').map(function(details) {
      return htmlSafe(details);
    });
  })
});
