/* globals Twitch */
import Component from 'ember-component';
import {
  LAUNCHER as launcher,
  LAUNCHER_INFO as launcherInfo
} from 'web-client/utilities/urls/fuel';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  classNames: ['brick', ' brick--pd-none', 'brick--theme-white', 'mg-b-2'],
  launcher,
  launcherInfo,
  session: injectService(),
  tracking: injectService(),
  userData: computed.alias('session.userData'),
  userCanAcquireGame: false,
  didReceiveAttrs() {
    let alreadyOwns = this.get('gameDetail.userEntitlement.entitled');
    let availableFree = !!this.get('offer');
    let availablePaid = this.get('gameDetail.isForSale');
    this.set('userCanAcquireGame', alreadyOwns || availableFree || availablePaid);
  },

  actions: {
    trackFlow() {
      let eventData = {
        login: this.get('userData.login'),
        user_id: this.get('userData.id'),
        device_id: Twitch.idsForMixpanel.getOrCreateUniqueId(),
        client_time: new Date().getTime(),
        location: 'game_detail',
        game: this.get('gameDetail.product.title'),
        channel: this.get('broadcasterName'),
        urls: this.get('launcher')
      };

      this.get('tracking').trackEvent({
        event: 'fuel_download_launcher',
        data: eventData
      });
    }
  }
});
