
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import observer from 'ember-metal/observer';
import run from 'ember-runloop';

export default Component.extend({
  layout: injectService(),
  classNames: ['game-details--old'],

  didInsertElement() {
    this._super(...arguments);

    let imageSrc = `url(${this.get('product.media.background_image_url')})`;
    this.$('.details-backdrop').css('background-image', imageSrc);
    this.get('layout.contentWidth'); // trigger the layout observer

    this.$().find('img').one('load', function() {
      run.debounce(this, this._setBackdropHeight, 1); // Delay this by 1ms to ensure images have proper size.
    }.bind(this));
  },

  resizeObserver: observer('layout.contentWidth', function() {
    this.debounceTask('_setBackdropHeight', 100);
  }),

  _setBackdropHeight() {
    let navHeight = this.$('.directory_header').outerHeight(true);
    let navTop = this.$('.directory_header').position().top;
    let carouselHeight = this.$('.carousel').height();
    let carouselTop = this.$('.carousel').position().top;
    let bottomPadding = 30; // We want the background to drop down another 30px below the carousel
    let height = `${navHeight + navTop + carouselHeight + carouselTop + bottomPadding}px`;
    this.$('.details-backdrop').css('height', height);
  }
});
