import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const DETAILS_SIDEBAR_WIDTH = 320;
const DETAILS_MIN_WIDTH = 320;
const DETAILS_SIDEBAR_LEFT_MARGIN = 30;

export default Component.extend({
  classNames: ['game-details', 'mg-b-6'],
  layout: injectService(),
  store: injectService(),

  // Provided by route & route template
  gameDetail: null,
  broadcasterId: null,
  broadcasterName: null,

  // Set during init (async)
  offer: null, // Direct Entitlement offer for this game

  hasSpaceForSidebar: computed('layout.contentWidth', function() {
    return (this.get('layout.contentWidth') - DETAILS_SIDEBAR_LEFT_MARGIN - DETAILS_SIDEBAR_WIDTH) >= DETAILS_MIN_WIDTH;
  }),

  hasVideos: computed.notEmpty('gameDetail.product.media.videos'),
  hasImages: computed.notEmpty('gameDetail.product.media.screenshot_urls'),
  hasMedia: computed.and('hasVideos', 'hasImages'),
  hasNoMedia: computed('hasVideos', 'hasImages', function () {
    return !this.get('hasVideos') && !this.get('hasImages');
  }),

  init() {
    this._super(...arguments);
    return this.get('store').findAll('offer').then((offers) => {
      if (this.isDestroyed) { return; }

      //TODO: Scotch in the morning? Sure, why not... also, let's not use game names as IDs.
      let gameTitle = this.get('gameDetail.product.title');
      if (gameTitle === "The Walking Dead") {
        gameTitle = "The Walking Dead: Season 1 (WIN)";
      } else if (gameTitle === "The Walking Dead: Season Two") {
        gameTitle = "The Walking Dead: Season 2 (WIN)";
      }

      let offer = offers.find((item) => {
        return item.get('applicableGame').indexOf(gameTitle) === 0;
      }, gameTitle);
      if (offer &&
        offer.get('contentDeliveryMethod') === 'DIRECT_ENTITLEMENT' &&
        offer.get('isLive')) {
        this.set('offer', offer);
      }
    });
  }
});
