import Component from 'ember-component';
import observer from 'ember-metal/observer';
import injectService from 'ember-service/inject';

const CAROUSEL_SELECTOR = '.game-details__carousel';
const CAROUSEL_NAV_BTNS_SELECTOR = '.game-details__carousel-nav a';

export default Component.extend({
  classNames: ['game-details__gallery', 'js-game-details-gallery'],
  layout: injectService(),

  // array of image URLs
  imageUrls: null,

  didInsertElement() {
    this._super(...arguments);

    this.get('layout.contentWidth'); // trigger the layout observer
    this.$(CAROUSEL_SELECTOR).flexslider({
      animation: 'slide',
      slideshow: false,
      customDirectionNav: this.$(CAROUSEL_NAV_BTNS_SELECTOR)
    });
  },

  willDestroyElement() {
    this._super(...arguments);
    this.$(CAROUSEL_SELECTOR).flexslider('destroy');
  },

  observeDimensions: observer('layout.contentWidth', function() {
    this.debounceTask('_updateCarousel', 100);
  }),

  _updateCarousel() {
    // trigger resize of window which will trigger flexslider to recalculate size of carousel
    this.$(window).trigger('resize');
  }
});
