import Component from 'ember-component';

export default Component.extend({
  classNames: ['game-details'],
  didInsertElement() {
    this._super(...arguments);

    let imageSrc = `url(${this.get('product.media.background_image_url')})`;
    this.$('.game-details__backdrop').css('background-image', imageSrc);

    this.$().find('img').one('load', function() {
      this.debounceTask('_setBackdropHeight', 1); // Delay this by 1ms to ensure images have proper size.
    }.bind(this));
  },

  _setBackdropHeight() {
    let navHeight = this.$('.directory_header').outerHeight(true);
    let navTop = this.$('.directory_header').position().top;
    this.$('.game-details__backdrop').css('height', navHeight + navTop);
  }
});
