import Component from 'ember-component';

export default Component.extend({
  classNames: ['specification__item', 'flex', 'flex--nowrap', 'js-game-details-detail'],

  firstDetail: null,
  hasMultipleDetails: null,

  didReceiveAttrs() {
    this._super(...arguments);

    let details = this.get('details');

    if (Array.isArray(details)) {
      this.set('hasMultipleDetails', details.length > 1);
      this.set('firstDetail', details[0]);
    } else if (details !== null) {
      this.set('hasMultipleDetails', false);
      this.set('firstDetail', details);
    }
  }
});
