import Component from 'ember-component';
import computed from 'ember-computed';

const CAROUSEL_SELECTOR = '.game-details__carousel';
const CAROUSEL_NAV_BTNS_SELECTOR = '.game-details__carousel-nav a';
const CAROUSEL_ITEM_WIDTH = 360;
const CAROUSEL_ITEM_SPACING = 20;

export default Component.extend({
  classNames: ['game-details__videos', 'js-game-details-videos'],

  // array of videos ({video_id})
  videos: null,

  didInsertElement() {
    this._super(...arguments);

    if (this.get('hasMultipleVideos')) {
      this.$(CAROUSEL_SELECTOR).flexslider({
        animation: 'slide',
        slideshow: false,
        customDirectionNav: this.$(CAROUSEL_NAV_BTNS_SELECTOR),
        itemWidth: CAROUSEL_ITEM_WIDTH,
        itemMargin: CAROUSEL_ITEM_SPACING
      });
    }
  },

  willDestroyElement() {
    this._super(...arguments);
    this.$(CAROUSEL_SELECTOR).flexslider('destroy');
  },

  hasMultipleVideos: computed('videos', function () {
    let videos = this.get('videos');
    return videos && videos.length > 1;
  }),

  firstVideo: computed('videos', function () {
    let videos = this.get('videos');
    if (videos) {
      return videos[0];
    }
    return null;
  })
});
