import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  embeds: injectService(),

  // provided by parent
  videoId: null,

  // set in init
  embed: null,

  didReceiveAttrs() {
    this._super(...arguments);

    let videoId = this.get('videoId');
    if (videoId.charAt(0) === 'v') {
      videoId = videoId.slice(1);
    }

    // TODO construct the URL better
    this.get('embeds').getEmbed(`https://www.twitch.tv/videos/${videoId}`).then((embed) => {
      this.set('embed', embed);
    });
  }
});
