import EmberObject from 'ember-object';
import { assign } from 'ember-platform';
import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import $ from 'jquery';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import FilterTrackingMixin from 'web-client/mixins/filter-tracking';

const INIT_TRACKING_EVENT = 'language_filter_init';
const ACTION_TRACKING_EVENT = 'language_filter_action';

export default Component.extend(FilterTrackingMixin, SendRouteActionMixin, {
  languageDirectoryFilter: injectService(),
  tracking: injectService(),

  numSelectedFilters: computed('languageDirectoryFilter.languageFilters', function () {
    return this.get('languageDirectoryFilter.languageFilters').length;
  }),

  numSelectedFiltersIsViewable: computed('numSelectedFilters', function () {
    return this.get('numSelectedFilters') > 0;
  }),

  broadcasterLanguageCheckboxes: null,

  broadcasterLanguagesScroll: computed.alias('languageDirectoryFilter.languages'),

  languageTrackingData: computed('languageDirectoryFilter.languageFilters', function() {
    let filters = this.get('languageDirectoryFilter.languageFilters');
    return {
      all_languages_selected: filters.join(','),
      num_languages_selected: filters.length
    };
  }),

  isSortOptionsVisible: false,

  didInsertElement() {
    this.addEventListener('.js-language-filter', 'clickoutside', () => {
      this.set('isSortOptionsVisible', false);
    });

    $('.js-language-balloon .scroll').TrackpadScrollEmulator({
      wrapContent: false,
      scrollbarHideStrategy: 'rightAndBottom'
    });

    this._initLanguageCheckboxes();
  },

  willDestroyElement() {
    if ($('.js-language-balloon .scroll').data('plugin_TrackpadScrollEmulator')) {
      $('.js-language-balloon .scroll').TrackpadScrollEmulator('destroy');
    }
    this._super(...arguments);
  },

  _initLanguageCheckboxes() {
    let languageCheckboxes = EmberObject.create();
    this.get('languageDirectoryFilter.languageFilters').forEach((languageCode) => {
      languageCheckboxes[languageCode] = true;
    });

    this.set('broadcasterLanguageCheckboxes', languageCheckboxes);
    this.trackEvent(INIT_TRACKING_EVENT, this.get('languageTrackingData'));
  },

  _animateNumLanguages() {
    let languageIndicator = this.$('.js-language-indicator');
    languageIndicator.addClass('anim-bounce');
    this.runTask(() => {
      languageIndicator.removeClass('anim-bounce');
    }, 400);
  },

  _trackFilterAction(language, isSelected) {
    let languageData = this.get('languageTrackingData');
    assign(languageData, {
      language_changed: language,
      language_selected: isSelected
    });

    this.trackEvent(ACTION_TRACKING_EVENT, languageData);
  },

  actions: {
    checkboxChanged(language) {
      let broadcasterLanguageCheckboxes = this.get('broadcasterLanguageCheckboxes');
      let wasChecked = broadcasterLanguageCheckboxes[language] === true;

      let properties = {};
      properties[language] = !wasChecked;
      broadcasterLanguageCheckboxes.setProperties(properties);

      if (wasChecked) {
        delete broadcasterLanguageCheckboxes[language];
      }

      this.set('broadcasterLanguageCheckboxes', broadcasterLanguageCheckboxes);
      this.get('languageDirectoryFilter').setLanguageFilters(Object.keys(broadcasterLanguageCheckboxes));
      this._animateNumLanguages();

      this._trackFilterAction(language, !wasChecked);
      this.sendRouteAction('refreshModel');
    },

    clearFilters() {
      this.get('languageDirectoryFilter').setLanguageFilters([]);
      this.set('broadcasterLanguageCheckboxes', EmberObject.create());

      this._trackFilterAction(null, null);
      this.sendRouteAction('refreshModel');
    },

    toggleSortOptions() {
      let isSortOptionsVisible = this.get('isSortOptionsVisible');
      this.set('isSortOptionsVisible', !isSortOptionsVisible);
    }
  }
});
