import Component from 'ember-component';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import run from 'ember-runloop';


export default Component.extend(InteractivityDeferredComponent, {
  globals: injectService(),
  layout: injectService(),
  experiments: injectService(),

  isRightColumnClosed: computed.readOnly('layout.isRightColumnClosed'),
  isInMaintenanceMode: computed.alias('globals.isInMaintenanceMode'),

  // isLoading flag prevents us from initializing a component momentarily
  // and then destroying it / initializing a separate component when
  // we receive experiments information. These right-column components
  // incur fairly heavy API requests and we don't want to add extra load
  // unless necessary.
  isLoading: true,

  isWatchNowEnabled: false,

  init() {
    this._super(...arguments);
    this.get('experiments').getExperimentValue('WATCH_NOW_RIGHTBAR').then((variant) => {
      if (this.isDestroyed) { return; }
      this.set('isWatchNowEnabled', variant === 'treatment');
    }).finally(() => {
      if (this.isDestroyed) { return; }
      this.set('isLoading', false);
    });
  },
  didInsertElement() {
    this._super(...arguments);
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
