import Component from 'ember-component';
import computed from 'ember-computed';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import run from 'ember-runloop';

export default Component.extend(InteractivityDeferredComponent, {
  stream: null,
  tt_content: null,
  tt_medium: null,
  tt_content_index: null,

  // routerChannel provides a channel object with a valid ID field the router action
  // handleStreamClick expects
  routerChannel: computed('stream', function() {
    if (this.get('stream.channel.name')) {
      return { id: this.get('stream.channel.name') };
    }
    return this.get('stream');
  }),
  didInsertElement() {
    this._super(...arguments);
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
