import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { scheduleOnce } from 'ember-runloop';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';

export default Component.extend(InteractivityDeferredComponent, {
  layout: injectService(),

  classNames: ['js-videos-list'],

  didInsertElement() {
    this._super(...arguments);
    scheduleOnce('afterRender', this, this.reportInteractive);
  },

  actions: {
    loadMore: function () {
      let model = this.get('model');

      if (model) {
        model.loadMore();
      }
    }
  }
});
