import Component from 'ember-component';
import computed from 'ember-computed';
import observer from 'ember-metal/observer';

export default Component.extend({
  tagName: 'iframe',
  classNames: ['facebook_like_button'],
  attributeBindings: ['src', 'width', 'height'],
  attributes: ['scrolling:no', 'frameborder:0', 'allowTransparency:true'],

  src: computed('url', function () {
    return `//www.facebook.com/plugins/like.php?href=${this.get('url')}&layout=button_count&show_faces=false&width=${this.get('width')}&action=like&colorscheme=light&height=${this.get('height')}`;
  }),

  srcChange: observer('src', function () {
    // this re-render prevents the duplicate history back stack bug
    // related: http://stackoverflow.com/questions/821359/reload-an-iframe-without-adding-to-the-history
    // details: https://www.facebook.com/yoh.suzuki/posts/10102834334028767?comment_id=21773222
    this.rerender();
  }),

  width: 90,
  height: 21
});
