/* globals Twitch*/
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  feeds: injectService(),
  tracking: injectService(),
  isOptedIntoChannelFeed: null,

  actions: {
    toggleChannelFeed() {
      let setChannelFeedEnabled = !this.get('isOptedIntoChannelFeed');
      let userLogin = this.get('userLogin');
      let feeds = this.get('feeds');

      feeds.toggleChannelFeed(setChannelFeedEnabled, userLogin).then(() => {
        if (this.isDestroyed) { return; }
        this.set('isOptedIntoChannelFeed', setChannelFeedEnabled);

        this.get('tracking').trackEvent({
          event: 'channel_feed_beta',
          data: {
            device_id: Twitch.idsForMixpanel.getOrCreateUniqueId(),
            login: userLogin,
            beta: setChannelFeedEnabled
          }
        });
      }, e => {
        Twitch.notify.error(window.i18n('There was a problem updating your channel feed. Please try again.'));
        throw e;
      });
    }
  }
});
