import Component from 'ember-component';
import getFileFromEvent from 'web-client/utilities/get-file-from-event';

export default Component.extend({
  tagName: 'label',
  classNames: ['button', 'button--file'],

  // Optional injected action
  onOpenPicker() {},

  didInsertElement() {
    this.$().attr('title', this.get('title'));
  },

  click(event) {
    this.get('onOpenPicker')(event);
  },

  actions: {
    onChange(event) {
      let file = getFileFromEvent(event);
      this.get('onChange')(file);
      this.$('form')[0].reset();
    }
  }
});
