import Component from 'ember-component';
import {
  SORT_PERIOD_DAY,
  SORT_PERIOD_WEEK,
  SORT_PERIOD_MONTH,
  SORT_PERIOD_ALL,
  SORT_TRENDING
} from 'web-client/adapters/clip';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';

const SORT_OPTIONS = [
  SORT_TRENDING,
  SORT_PERIOD_DAY,
  SORT_PERIOD_WEEK,
  SORT_PERIOD_MONTH,
  SORT_PERIOD_ALL
];

export const TEST_SELECTOR = 'clips-sort';
export const DROPDOWN_TEST_SELECTOR = 'clips-sort-dropdown';

export default Component.extend(SendRouteActionMixin, {
  classNames: ['js-clips-filter', 'balloon-wrapper'],
  testSelector: TEST_SELECTOR,
  attributeBindings: ['testSelector:data-test-selector'],

  selectedSortOption: SORT_PERIOD_DAY,

  isDropdownHidden: true,
  sortOptions: SORT_OPTIONS,
  dropdownTestSelector: DROPDOWN_TEST_SELECTOR,

  didInsertElement() {
    this.addEventListener('.js-clips-filter', 'clickoutside', () => {
      this.set('isDropdownHidden', true);
    });
  },

  actions: {
    toggleDropdown() {
      this.toggleProperty('isDropdownHidden');
    },
    changeSortOption(sortOption) {
      this.sendRouteAction('changeClipsSortOption', sortOption);
    }
  }
});
