/* globals i18n */

import Component from 'ember-component';
import computed from 'ember-computed';

const PLATFORM_TYPES = [{
  name: 'All Platforms',
  route: 'directory.channels.all'
},{
  name: 'Xbox One',
  route: 'directory.channels.xbOne'
},{
  name: 'PlayStation 4',
  route: 'directory.channels.psFour'
}];

export default Component.extend({
  selectedNavigationItem: null,
  isPlatformNavigationVisible: false,

  selectedNavigationLabel: computed('selectedNavigationItem', function () {
    let type = this.get('selectedNavigationItem');
    switch (type) {
      case 'top':
        return i18n('All Platforms');
      case 'psFour':
        return 'PlayStation 4';
      case 'xbOne':
        return 'Xbox One';
      default:
        return '';
    }
  }),

  platformTypes: PLATFORM_TYPES,

  didInsertElement() {
    this.addEventListener('.js-platform-filter', 'clickoutside', () => {
      this.set('isPlatformNavigationVisible', false);
    });
  },

  actions: {
    togglePlatformNavigation() {
      this.toggleProperty('isPlatformNavigationVisible');
    }
  }
});
