import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  routing: injectService('-routing'),

  isChannelsAll: computed.equal('routing.currentRouteName', 'directory.channels.all'),
  isChannelsBroadcasterLanguage: computed.equal('routing.currentRouteName', 'directory.channels.broadcasterLanguage'),
  isChannelsPsFour: computed.equal('routing.currentRouteName', 'directory.channels.psFour'),
  isChannelsXbOne: computed.equal('routing.currentRouteName', 'directory.channels.xbOne'),

  isChannelsRoute: computed.or('isChannelsAll', 'isChannelsBroadcasterLanguage', 'isChannelsPsFour', 'isChannelsXbOne'),
  isVideosRoute: computed.equal('routing.currentRouteName', 'directory.videos.video-type')
});
