import Component from 'ember-component';
import FilterTrackingMixin from 'web-client/mixins/filter-tracking';

const VIDEO_SORT_CHANGE_ACTION = 'sort_type_action';

export default Component.extend(FilterTrackingMixin, {
  isSortNavigationVisible: false,
  selectedSort: null,

  didInsertElement() {
    this.addEventListener('.js-vod-filter', 'clickoutside', () => {
      this.set('isSortNavigationVisible', false);
    });

    // fire event on load
    this.trackEvent(VIDEO_SORT_CHANGE_ACTION, { sorting_type: this.get('selectedSort') });
  },

  actions: {
    toggleSortNavigation() {
      this.toggleProperty('isSortNavigationVisible');
    },
    changeSort(sortType) {
      if (sortType === this.selectedSort) {
        return;
      }
      this.sendAction('changeSort', sortType);
      this.trackEvent(VIDEO_SORT_CHANGE_ACTION, { sorting_type: sortType });
    }
  }
});
