import Component from 'ember-component';
import FilterTrackingMixin from 'web-client/mixins/filter-tracking';

const VIDEO_TYPE_FILTER_CHANGE_ACTION = 'vod_type_filter_action';

export default Component.extend(FilterTrackingMixin, {
  isVideoNavigationVisible: false,
  selectedNavigationItem: null,

  didInsertElement() {
    this.addEventListener('.js-vod-filter', 'clickoutside', () => {
      this.set('isVideoNavigationVisible', false);
    });

    // fire event on load
    this.trackEvent(VIDEO_TYPE_FILTER_CHANGE_ACTION, { vod_type: this.get('selectedNavigationItem') });
  },

  actions: {
    toggleVideoNavigation() {
      this.toggleProperty('isVideoNavigationVisible');
    },
    changeType(videoType) {
      this.toggleProperty('isVideoNavigationVisible');
      this.trackEvent(VIDEO_TYPE_FILTER_CHANGE_ACTION, { vod_type: videoType });
    }
  }
});
