import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['carousel-nav'],
  tracking: injectService(),

  _trackFrontPageCarouselClick(stream, index) {
    let data = {
      carousel_index: index,
      promotion_was_scheduled: stream.schedule,
      channel: stream.channel.name,
      game: stream.game
    };

    this.get('tracking').trackEvent({
      event: 'frontpage-carousel-click',
      data
    });
  },

  actions: {
    selectStream(stream, index) {
      let selectStream = this.get('selectStream');
      if (selectStream) {
        selectStream({ stream, index });
      }

      this._trackFrontPageCarouselClick(stream, index);
    }
  }
});
