import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

const FRONT_PAGE_GAMES_LIMIT = 12;

export default Component.extend({
  store: injectService(),
  ads: injectService(),

  RECTANGLE_AD_DIMENSIONS: [
    [300, 250],
    [300, 600],
    [250, 600]
  ],

  featuredGames: computed(function() {
    let options = {
      kind: 'featured',
      front_page: true,
      limit: FRONT_PAGE_GAMES_LIMIT
    };

    this.get('store').query('game', options).then(featuredGames => {
      if (this.isDestroyed) { return; }
      this.set('featuredGames', featuredGames);
    });

    return [];
  }),

  topGames: computed(function() {
    let options = {
      kind: 'top',
      limit: FRONT_PAGE_GAMES_LIMIT
    };

    this.get('store').query('game', options).then(topGames => {
      if (this.isDestroyed) { return; }
      this.set('topGames', topGames);
    });

    return [];
  }),

  // Only display 12 total games including featured
  games: computed('topGames.[]', 'featuredGames.[]', function() {
    let topGames = this.get('topGames');
    let featuredGames = this.get('featuredGames').filterBy('featuredOnFrontPage', true);

    let games = featuredGames.map(game => {
      return { isFeatured: true, game };
    });

    topGames.slice(0, FRONT_PAGE_GAMES_LIMIT - games.length)
    .forEach(game => {
      games.push({ isFeatured: false, game });
    });

    return games;
  })
});
