import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import {
  FRONT_PAGE_HEADER_URL as primeBlogPostHref,
  US_BLACK_FRIDAY_URL as usBlackFridayUrl
} from 'web-client/utilities/urls/prime-urls';

export default Component.extend({
  tracking: injectService(),
  geo: injectService(),
  session: injectService(),
  globals: injectService(),

  primeBlogPostHref,
  usBlackFridayUrl,

  isShowBlackFriday: false,
  userData: computed.readOnly('session.userData'),

  init() {
    this._super(...arguments);
    this.get('geo').getGeo().then(geo => {
      let url = this.primeBlogPostHref;

      if(this.get('globals.primeBlackfridayPromoEnabled') && geo.geo === 'US') {
      //if(geo.geo === 'US') {
        this.set('isShowBlackFriday', true);
        url = this.usBlackFridayUrl;
      }
      this.set('offerUrl', url);
    });
  },

  didInsertElement() {
    this._super(...arguments);
    if(this.get('isShowBlackFriday')) {
      this._trackData('Twitch_BF_Banner');
    }
  },

  click() {
    if(this.get('isShowBlackFriday')) {
      this._trackData('Twitch_BF_Banner_click');
    }
  },

  _trackData(event){
    this.get('tracking').trackEvent({
      event: event,
      data: {
        userDataId: this.get('userData.id'),
        hasPrime: this.get('userData.hasPrime')
      }
    });
  }
});
