import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import {
  FRONT_PAGE_HEADER_URL as tryPrimeHeaderHref
} from 'web-client/utilities/urls/prime-urls';

export default Component.extend({
  session: injectService(),
  geo: injectService('premium-geo'),

  showPrimeContent: computed.readOnly('geo.showPrimeContent'),

  hasTwitchPrime: computed.readOnly('session.userData.has_premium'),
  hasTurbo: computed.readOnly('session.userData.has_turbo'),

  tryPrimeHeaderHref,

  showTryTwitchPrime: computed('showPrimeContent', 'hasTwitchPrime', function(){
    return this.get('showPrimeContent') && !this.get('hasTwitchPrime');
  }),

  showGoTurbo: computed('showPrimeContent', 'hasTurbo', function() {
    return !this.get('showPrimeContent') && (
      !this.get('session').isAuthenticated || !this.get('hasTurbo')
    );
  }),

  showTwitchUpsell: computed.or('showTryTwitchPrime', 'showGoTurbo')
});
