import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  session: injectService(),
  api: injectService(),

  show: false,
  isLoggedIn: false,
  hasTurbo: null,

  init() {
    this._super(...arguments);

    let { isAuthenticated, userData } = this.get('session');

    if (isAuthenticated) {
      this.set('hasTurbo', userData.has_turbo);
    }
  },

  showGoTurbo: computed.not('hasTurbo')
});
