import Component from 'ember-component';
import injectService from 'ember-service/inject';
import ClickOutsideMixin from 'web-client/mixins/click-outside';

export default Component.extend(ClickOutsideMixin, {
  tagName: 'span',
  classNames: ['balloon-wrapper', 'float-left'],
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService('login'),
  isUserMenuOpen: false,

  clickedOutside() {
    this.set('isUserMenuOpen', false);
  },

  actions: {
    toggleUserMenu() {
      this.toggleProperty('isUserMenuOpen');
    }
  }
});
