import Component from 'ember-component';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';
import StreamModel from 'web-client/models/deprecated-stream';
import Host from 'web-client/models/host';

export default Component.extend({
  store: injectService(),
  vodCoviews: injectService(),

  streams: null,
  hosts: null,
  topGames: null,
  followedGames: null,

  init() {
    this._super();

    this.set('loading', true);

    RSVP.hashSettled({
      streams: StreamModel.find('live').load(true),
      hosts: Host.find('following').load(true),
      topGames: this.get('store').query('game', {kind: 'top'}),
      followedGames: this.get('store').query('game', {kind: 'followedLive'}),
      vodCoviewsExperiment: this.get('vodCoviews').checkExperiment(),
      vodCoviewsVods: this.get('vodCoviews').findVodCoviews()
    }).then(hash => {
      for (let key in hash) {
        if (hash.hasOwnProperty(key)) {
          this.set(key, hash[key].value !== undefined ? hash[key].value : []);
        }
      }
      this.set('loading', false);
    });
  }
});
