import DirectoryCoViews from '../../../video/coviews/directory-container/component';
import injectService from 'ember-service/inject';
import SendRouteAction from 'web-client/mixins/send-route-action';

export default DirectoryCoViews.extend(SendRouteAction, {
  feeds: injectService(),
  actions: {
    trackAndTransition(params) {
      let id = params.video.id.replace('v', '');
      let url = `/videos/${id}`;
      this.get('feeds').trackEvent('home_page_link_click', this.get('trackingInfo'), {url});
      this.sendRouteAction('handleVideoClick', params.video, params.index, params.totalVideos);
    }
  }
});
