import Component from 'ember-component';
import computed from 'ember-computed';
import { assert } from 'ember-metal/utils';

const TYPES = {
  live: {
    title: 'Top Live Channels',
    subtitle: 'Broadcasters people are watching now',
    linkText: 'See all live Channels',
    linkTarget: 'directory.channels.all',
    ttContent: 'top_channels',
    listElementId: 'top-channels',
    customClass: ''
  },
  psFour: {
    title: 'Top PS4 Channels',
    subtitle: 'Channels broadcasted from PlayStation 4',
    linkText: 'See all PS4 Channels',
    linkTarget: 'directory.channels.psFour',
    ttContent: 'top_psFour',
    listElementId: 'psFour-channels',
    customClass: 'js-top-psFour'
  },
  xbox: {
    title: 'Top Xbox One Channels',
    subtitle: 'Channels broadcasted from Xbox One',
    linkText: 'See all Xbox One Channels',
    linkTarget: 'directory.channels.xbOne',
    ttContent: 'top_xbox',
    listElementId: 'xbOne-channels',
    customClass: 'js-top-xbox'
  }
};


const INTL_I18N_TYPES_OVERRIDES =  {
  live: {
    title: 'frontPage.streamList.live.title',
    subtitle: 'frontPage.streamList.live.subtitle',
    linkText: 'frontPage.streamList.live.linkText'
  },
  psFour: {
    title: 'frontPage.streamList.psFour.title',
    subtitle: 'frontPage.streamList.psFour.subtitle',
    linkText: 'frontPage.streamList.psFour.linkText'
  },
  xbox: {
    title: 'frontPage.streamList.xbox.title',
    subtitle: 'frontPage.streamList.xbox.subtitle',
    linkText: 'frontPage.streamList.xbox.linkText'
  }
};


function mappedComputed() {
  return computed('type', function(property) {
    let type = this.get('type');
    let props = TYPES[type];
    assert(`property '${property}' not found for type '${type}'`, props && props[property] !== undefined);
    return props[property];
  });
}

function intlMappedComputed(property) {
  return computed('type', function() {
    let type = this.get('type');
    let props = INTL_I18N_TYPES_OVERRIDES[type];
    if (props && props[property] === undefined) {
      console.warn(`property '${property}' not found for type '${type}' in Intl overrides`);
      return '';
    }

    return props[property];
  });
}

export default Component.extend({
  classNames: ['video_grid', 'wrapper'],
  classNameBindings: ['customClass'],
  type: 'live',
  TYPES: null,

  title: mappedComputed(),
  subtitle: mappedComputed(),
  ttContent: mappedComputed(),
  linkText: mappedComputed(),
  linkTarget: mappedComputed(),
  listElementId: mappedComputed(),
  customClass: mappedComputed(),

  intlTitle: intlMappedComputed('title'),
  intlSubtitle: intlMappedComputed('subtitle'),
  intlLinkText: intlMappedComputed('linkText')
});
