import Ember from 'ember';

const { Component, computed } = Ember;

export default Component.extend({
  classNames: ['ct-thumb', 'ct-spotlight__thumb'],
  classNameBindings: ['isActive:active'],
  stream: null,
  hero: null,
  channel: computed.alias('stream.channel'),
  preview: computed.alias('stream.preview.large'),
  isActive: computed('hero.id', 'stream.id', function () {
    return this.get('hero.id') === this.get('stream.id');
  }),

  actions: {
    setChannel: function () {
      this.sendAction('action', this.get('stream'));
    }
  }
});
