import computed from 'ember-computed';
import Component from 'ember-component';

export const BASE_URL = "//static-cdn.jtvnw.net/ttv-boxart";

export const SIZES = {
  large: "272x380",
  medium: "136x190",
  small: "52x72"
};

let GameArt = Component.extend({
  tagName: 'img',
  attributeBindings: ['src'],

  src: computed('name', 'size', function() {
    let name = encodeURI(this.get('name'));
    return `${BASE_URL}/${name}-${SIZES[this.get('size')]}.jpg`;
  })
});

GameArt.reopenClass({
  positionalParams: ['name', 'size']
});

export default GameArt;
