import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: [ 'js-player '],

  layout: injectService(),

  didInsertElement() {
    this._super(...arguments);
    this._setHighlightPlayerHeight();
  },

  _setHighlightPlayerHeight() {
    let highlightPlayer = this.$('#player');
    let playerControlsHeight = this.get('layout.PLAYER_CONTROLS_HEIGHT');

    let computeNewHeight = () => {
      let newHeight = (highlightPlayer.width() * 9 / 16) + playerControlsHeight;
      return `${newHeight.toFixed(0)}px`;
    };

    highlightPlayer.height(computeNewHeight);

    this.addEventListener(window, 'resize', () => {
      highlightPlayer.height(computeNewHeight);
    });
  }

});
