import computed from 'ember-computed';
import Component from 'ember-component';

 /*
  Use when there is a single placeholder that needs to be replaced with a template.
  
  translation: the translated string with the expected placeholder
  yieldKey: the placeholder for which the component will yield to the block statement (with the elem)
 */
export default Component.extend({
  tagName: 'span',
  translation: '',
  yieldKey: '',

  parts: computed('translation', 'yieldKey', function () {
    return this.get('translation').split(this.get('yieldKey'));
  })
});
