import Component from 'ember-component';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import run from 'ember-runloop';
import computed from 'ember-computed';

export default Component.extend(InteractivityDeferredComponent, {
  beaconId: '',
  latencyReportingId: computed('beaconId', function() {
    return `beacon:${this.get('beaconId')}`;
  }),
  didInsertElement() {
    this._super(...arguments);
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  }
});
