import $ from 'jquery';
import Component from 'ember-component';
import config from 'web-client/config/environment';

const LANGUAGES = config.LANGUAGES;
const colSize = Math.round(LANGUAGES.length / 2);

export default Component.extend({
  languages: {
    firstColumn: LANGUAGES.slice(0, colSize),
    secondColumn: LANGUAGES.slice(colSize)
  },

  isMenuOpen: false,

  _toggleMenu() {
    this.toggleProperty('isMenuOpen');
  },

  didInsertElement() {
    this._super(...arguments);

    this.addEventListener(document.body, 'click', e => {
      let $target = $(e.target);
      if (this.get('isMenuOpen') &&
        !$target.is('.js-language-balloon') &&
        !$target.is('.js-language-select')) {
        this._toggleMenu();
      }
    });
  },

  actions: {
    toggle() {
      this._toggleMenu();
    }
  }
});
